#pragma once

#include <boost/asio/buffer.hpp>
#include <boost/asio/deadline_timer.hpp>
#include <boost/asio/io_service.hpp>
#include <boost/asio/ip/tcp.hpp>
#include <chrono>

namespace telemetry {

/**
 * Wrapper for tcp boost::asio::socket
 */
class Socket {
 public:
  Socket(const std::string& host, unsigned short port,
         std::chrono::milliseconds connect_timeout);

  Socket(const Socket&) = delete;

  Socket& operator=(const Socket&) = delete;

  void Write(const uint8_t* buf, size_t size,
             std::chrono::milliseconds timeout);

  void Read(uint8_t* buf, size_t size, std::chrono::milliseconds timeout);

 private:
  void CheckDeadline();

 private:
  boost::asio::io_service io_service_;
  boost::asio::ip::tcp::socket socket_;
  boost::asio::deadline_timer deadline_;
};

}  // namespace telemetry
