#pragma once

#include <chrono>
#include <cstdint>

namespace utils {

struct GeoPoint {
  double lat;
  double lon;
};
}

namespace telemetry {

/**
 * Car telemetry information
 */
struct CarState {
  uint32_t id;
  double direction;
  double speed;
  std::chrono::system_clock::time_point timestamp;
  utils::GeoPoint coords;
  bool free;
  bool moving;
  bool asn = false;
  bool asnBusy = false;
  bool asnService = false;
};

}  // namespace telemetry
