# -*- coding: utf-8 -*-

from drive.backend.api import client as api


def register(group):
    cmd = group.add_parser("billing-emergency")
    cmd.set_defaults(main=main)
    cmd.add_argument("--type", default="emergency")

GVARS = {
    "billing.debt_threshold_on_perform": {
        "normal": str(0),
        "emergency": str(1000*100)
    },
    "billing.book.check_cards": {
        "normal": "true",
        "emergency": "false"
    },
    "billing.session_debt_threshold_override": {
        "normal": str(1024*100),
        "emergency": str(5000*100)
    },
    "billing.session_debt_threshold_deposit": {
        "normal": str(0),
        "emergency": str(5000*100)
    }
}


def main(opts):
    assert(opts.type in ["normal", "emergency"])
    for host in ("https://prestable.carsharing.yandex.net", "https://admin.carsharing.yandex.net"):
        client = api.BackendClient(host, require_public_token=False)
        client.add_settings(settings=[
            {
                "setting_key": key,
                "setting_value": value[opts.type]
            }
            for key, value in GVARS.items()
        ])
