from drive.backend.api import client as api


def compare_actual_sessions(client, args):
    client2 = api.BackendClient(endpoint=args.compare_endpoint2)
    sessions = client.get_actual_sessions()
    session_ids = []
    for session in sessions:
        session_ids.append(session['session_id'])

    sessions2 = client2.get_actual_sessions()
    session_ids2 = []
    for session in sessions2:
        session_ids2.append(session['session_id'])

    for session in sessions:
        session_id = session['session_id']
        if session_id not in session_ids2:
            print('missing in first: {}'.format(session))

    for session in sessions2:
        session_id = session['session_id']
        if session_id not in session_ids:
            print('missing in second: {}'.format(session))


def fill_parser(parser):
    parser.add_argument('--endpoint2', dest='compare_endpoint2', help='another endpoint', type=str)
    subparsers = parser.add_subparsers(help='entity')

    actions_parser = subparsers.add_parser('actual_sessions', help='actual sessions')
    actions_parser.set_defaults(func=compare_actual_sessions)
