_marks = {
    "a6 2018":      ["audi_a6", "audi_a6d"],
    "logan 2":      ["renault_logan"],
    "a3":           ["audi_a3", "audi_a3_w_for_long_term"],
    "q3":           ["audi_q3", "audi_q3_quattro"],
    "520i":         ["bmw_320d", "bmw_520i", "bmw_520i_w", "bmw_520i_restyling_2020", "bmw_520d_restyling_2020", "bmw_520d_xDrive_restyling_2020"],
    "jumpy":        ["citroen_jumpy", "peugeot_expert"],
    "genesis":      ["genesis_g70", "genesis_g70_w"],
    "rio":          ["kia_rio", "kia_rio_xline", "hyundai_solaris"],
    "e200":         ["mercedes_c180", "mercedes_c180_sport", "mercedes_e200", "mercedes_e200_w", "mercedes_e200_restyling_2020", "mercedes_e200d_restyling_2020"],
    "911":          ["porsche_carrera"],
    "macan":        ["porsche_macan"],
    "octavia":      ["skoda_octavia"],
    "rapid":        ["skoda_rapid", "volkswagen_polo_6", "skoda_rapid_2"],
    "kaptur":       ["renault_kaptur"],
    "polo":         ["vw_polo"],
    "xc60":         ["volvo_xc60", "volvo_xc60_diesel"],
    "velar":        ["range_rover_velar"],
    "transit":      ["ford_transit"],
    "qashqai":      ["nissan_qashqai"],
    "transporter":  ["volkswagen_transporter", "volkswagen_caravelle", "volkswagen_transporter_kombi"],
    "transp":       ["volkswagen_transporter", "volkswagen_caravelle", "volkswagen_transporter_kombi"],
    "creta":        ["hyundai_creta"],
    "solaris":      ["hyundai_solaris"],
    "x1":           ["bmw_X1", "bmw_X1_diesel"],
    "leaf":         ["nissan_leaf"],
    "xc40":         ["volvo_xc40", "volvo_xc40_diesel"],
    "rav4":         ["toyota_rav4"],
    "caddy":        ["volkswagen_caddy", "volkswagen_caddy_maxi"],
    "wrangler":     ["jeep_wrangler_sahara"],
    "a6":           ["audi_a6", "audi_a6d"],
    "duster":       ["renault_duster"],
    "lada_vesta":   ["lada_vesta"],
    "largus 20":    ["lada_largus"],
    "i30":          ["hyundai_i30"],
    "troc":         ["volkswagen_t-roc-cabrio"],
    "coolray":      ["geely_coolray"],
    "tiggo4_7pro":  ["chery_tiggo_4", "chery_tiggo_7_pro"]
}

DEVICE_MT_25K = "25K"
DEVICE_MT_32K_LTE = "32K LTE"
DEVICE_MT_32K_LTE_V2 = "32K LTE V2"
DEVICE_MT_32K_LTE_V3 = "32K LTE V3"


def create_alias(name, model):
    alias = name + '+' + model
    alias = alias.replace("'", '_')
    alias = alias.replace('"', '_')
    assert "'" not in alias
    assert '"' not in alias
    return alias


def deduce_device(name):
    if DEVICE_MT_32K_LTE_V3 in name:
        return DEVICE_MT_32K_LTE_V3
    if DEVICE_MT_32K_LTE_V2 in name:
        return DEVICE_MT_32K_LTE_V2
    if DEVICE_MT_32K_LTE in name:
        return DEVICE_MT_32K_LTE
    if DEVICE_MT_25K in name:
        return DEVICE_MT_25K
    return None


def deduce_models(name):
    normalized = name.lower()
    for mark, model in _marks.items():
        if mark in normalized:
            return model
    return None
