import logging
import json


def fill_parser(parser):
    parser.add_argument("--id", dest="rtbg_id", metavar="ID", type=str)
    parser.add_argument("--type", dest="rtbg_type", metavar="TYPE", type=str)
    parser.add_argument("--ctype", dest="rtbg_ctype", metavar="CTYPE", type=str, choices=['prestable_maps', 'testing_maps', 'drive_frontend_chat', 'drive_frontend_robot', 'rureggaeton09_prod'])
    parser.add_argument("--host_pattern", dest="rtbg_host_pattern", metavar="DC", type=str)
    parser.add_argument("--action", dest="rtbg_action", metavar="ACTION", help="action", type=str, choices=[
        'change_ctype',
        'change_host',
        'disable',
        'enable',
        'view',
    ])
    parser.add_argument("--target-host_pattern", dest="rtbg_target_host_pattern", metavar="DC", default='', type=str)
    parser.add_argument("--target-ctype", dest="rtbg_target_ctype", metavar="CTYPE", type=str, choices=[
        'prestable_maps',
        'testing_maps',
        'drive_frontend_chat',
        'drive_frontend_robot',
        'rureggaeton09_prod'
    ])


def execute(client, args):
    id = args.rtbg_id
    action = args.rtbg_action
    ids = [id] if id else []
    processes = client.list_rtbg(ids=ids)
    for process in processes:
        name = process["bp_name"]
        if id and name != id:
            continue

        if args.rtbg_type and process["bp_type"] != args.rtbg_type:
            continue

        ctype = process["bp_settings"]["host_filter"]["ctype"]
        if args.rtbg_ctype and ctype != args.rtbg_ctype:
            continue

        host_pattern = process["bp_settings"]["host_filter"].get("host_pattern")
        if args.rtbg_host_pattern and host_pattern != args.rtbg_host_pattern:
            continue

        if action == "view":
            print(json.dumps(process))
            continue
        if action == "enable":
            enabled = process["bp_settings"]["bp_enabled"]
            if enabled:
                continue
            logging.info("enabling {}".format(name))
            process["bp_settings"]["bp_enabled"] = True
            client.add_rtbg(process)
            continue
        if action == "disable":
            enabled = process["bp_settings"]["bp_enabled"]
            if not enabled:
                continue
            logging.info("disabling {}".format(name))
            process["bp_settings"]["bp_enabled"] = False
            client.add_rtbg(process)
            continue
        if action == "change_ctype":
            target_ctype = args.rtbg_target_ctype
            if ctype == target_ctype:
                continue
            logging.info("change {} ctype {} -> {}".format(name, ctype, target_ctype))
            process["bp_settings"]["host_filter"]["ctype"] = target_ctype
            client.add_rtbg(process)
            continue
        if action == "change_host":
            if host_pattern == args.rtbg_target_host_pattern:
                continue
            logging.info("change_host {} {}".format(name, host_pattern))
            process["bp_settings"]["host_filter"]["host_pattern"] = args.rtbg_target_host_pattern
            client.add_rtbg(process)
            continue

        raise NotImplementedError("unknown action: {}".format(action))
