import logging


def fill_parser(parser):
    subparsers = parser.add_subparsers(help='modes')
    iterate_parser = subparsers.add_parser('iterate', help='iterate through bills and refunds')
    iterate_parser.add_argument('--from', dest='iterate_from', type=int, default=0)
    iterate_parser.add_argument('--to', dest='iterate_to', type=int, default=0)
    iterate_parser.add_argument('--step', dest='iterate_step', type=int, default=10)
    iterate_parser.add_argument('--user-id', dest='iterate_user_id', type=str)


def execute_iterate(client, args):
    cursor = args.iterate_from
    to = args.iterate_to
    step = args.iterate_step
    user_id = args.iterate_user_id
    transactions = {}
    while (not to) or (cursor < to):
        nursor, sessions = client.get_bills_history(cursor, limit=step, delegate=user_id)
        logging.info('current={} next={} sessions={}'.format(cursor, nursor, len(sessions)))

        for session in sessions:
            account_name = session['account_name']
            event_id = session['sequential_id']
            session_id = session['service_order_id']
            transaction_id = session['transaction_id']
            tariff = session['tariff']
            print(event_id, session_id, transaction_id, tariff, account_name)
            if transaction_id in transactions:
                previous_session_id = transactions[transaction_id]
                logging.error('duplicated transaction {}: sessions {} and {}'.format(transaction_id, previous_session_id, session_id))
                return
            transactions[transaction_id] = session_id
        if nursor == cursor:
            logging.info('breaking')
            return
        cursor = nursor


def execute(client, args):
    if 'iterate_from' in args:
        execute_iterate(client, args)
        return
