# -*- coding: utf-8 -*-

from argparse import ArgumentParser
from .yt_profile import register as yt_profile_register
from .backend import register as backend_register
from .billing import register as billing_register
from .models import register as models_register
from drive.devops.cli.client.main import register as client_register
from drive.devops.cli.migrations.migrations import register as migrations_register


def main():
    cmd = ArgumentParser()
    group = cmd.add_subparsers(dest="cmd")
    group.required = True
    # Register subcommands here.
    yt_profile_register(group)
    backend_register(group)
    billing_register(group)
    client_register(group)
    models_register(group)
    migrations_register(group)
    # Run command.
    opts = cmd.parse_args()
    opts.main(opts)


if __name__ == "__main__":
    main()
