from os import listdir
from os.path import join, expanduser
from contextlib import suppress
from library.python.vault_client.instances import Production as YavClient
from library.python.vault_client.auth import BaseRSAAuth
from paramiko import RSAKey
from paramiko.ssh_exception import SSHException


class SSHAuth(BaseRSAAuth):
    def __init__(self):
        super(SSHAuth, self).__init__()
        ssh_dir = expanduser("~/.ssh")
        for file in listdir(ssh_dir):
            with suppress(SSHException):
                key = RSAKey.from_private_key_file(join(ssh_dir, file))
                self.keys.append(key)


class VaultClient:
    def __init__(self):
        self._client = YavClient(decode_files=True)
        self._ssh_client = None
        with suppress(Exception):
            self._ssh_client = YavClient(rsa_auth=SSHAuth(), decode_files=True)

    def get_version(self, version):
        try:
            return self._client.get_version(version)
        except:
            if not self._ssh_client:
                raise
            return self._ssh_client.get_version(version)
