# Радар

## Конфигурирование

Для радара используется тег `radar_user_tag`, поэтому необходимо его добавить с тем же именем и типом, если его нет.
Для запуска робота радара, необходимо будет его добавить с типом `radar_user_tag_process`.

Робот радара используется в тех случаях, если на момент завершения аренды машины, она осталась свободной по разным причинам (пример: не было подходящего радар пользователя).

Конфигурирование радара в основном осуществляется через использование GVars:

### Ручки

* `radar.create_tag.enabled` (булевое значение) &mdash; в `user_app/scanner/start` хендлере нужно указать данное значение как `true` для возможности создания тега радара.

    Передача пользователем полигона поиска, является опциональным параметром. Если с клиента данный параметр не передается в запросе, то значение достается с роутера.
* `radar.search_area.request_timeout` (действительное число) &mdash; значение `timeout` при получения полигона с роутера.

* `radar.pedestrian_router.isochrone_enabled` (булевое значение) &mdash; в `user_app/scanner/areas` хендлере нужно указать данное значение как `true` для возможности использования карточного роутера для построения зон.

### Включение радара

* `radar.close_session.enabled` (булевое значение) &mdash; указать как `true` для выдачи машины завершающую аренду, пользователям радара.

### Отправка пушей

* `radar.found.push_tag_name` (строка) &mdash; название имени пуша отправляемая пользователю не включавшему автобронь. При его отсутствии дефолтное значение возьмется с `radarpush_found`.
* `radar.booked.push_tag_name` (строка) &mdash; название имени пуша отправляемая пользователю включавшему автобронь. При его отсутствии дефолтное значение возьмется с `radarpush_booked`.
* `radar.robot_user_id` (строка) &mdash; id робота отправляющий пуш уведомление пользователю. При его отсутствии дефолтное значение возьмется с `robot-user-radar`.

### GeoHash

Технология `geohash` внедрена как дополнительная оптимизация поиска юзеров с навешенным тегом `radar_user_tag` по картам.

* `radar.use_geohash_add` (булевое значение) &mdash; указать как `true` для добавления геохешей с опреденным `precision` по сохраненному полигону пользователя в базу данных.
* `radar.use_geohash_remove` (булевое значение) &mdash; указать как `true` для удаления геохешей с опреденным `precision` после удаления тега `radar_user_tag` из базы данных.
* `radar.use_geohash_find` (булевое значение) &mdash; указать как `true` для поиска по определенному `precision` пользователей с навешенным тегом `radar_user_tag` по картам.

* `radar.set_geohash_precision` (действительное число) &mdash; значение `precision` устанавливаемая в полигон пользователя.
* `radar.get_geohash_precision` (действительное число) &mdash; значение `precision` читаемая из полигона пользователя.
