# Абонемент

## Ручка usep_app/subscription/info

Поля, отдаваемые API:

```(bash)
{
    "info" : {
        "balance" : {
            "description" : "1 бонус = 1Р",
            "bonuses" : {
                "cash" : 0
            },
            "bg_color" : "#ffffff"
        },
        "status": {
            "type" : "...",
            "name" : "базовый",
            "details" : "Это самый минимальный статус, который...",
            "color" : "#ffffff", // цвет плашки статуса
            "bg_color" : "#ffffff", // цвет фона
            "status" : "В обработке" // (ждём оплату), "навсегда" -- дефолтный статус, "до 31 сентября 2022" -- для активного абонемента
        },
        "taxi" : { // если доступны поездки на такси
            "description": "поездок на такси",
            "icon": "https://...",
            "rides": "10/10",
            "bg_color" : "#ffffff", // цвет фона
        },
        "error": { // данное поле может отсутствовать
            "description" : "оплата не прошла", // если есть какие-то ошибки
            "icon" : "https://..."
        },
        "description" : "Вы кладете деньги на счет и получаете ...",
        "tag_id" : "554a78c5-941c-435c-a91f-383fa177c4d5"
    },
    "description" : "какие варианты",
    "subscriptions" : [ //две подписки
        {
            "type" : "...", // тип абонемента
            "name" : "улучшенный",
            "description" : "что входит",
            "details" : [
                {
                    "name" : "riding",
                    "description" : "1500Р на поездки",
                    "icon" : "https://",
                    "type" : "type" // здесь можно указать тип в виде строки, чтобы отличать плюшку от разделителя
                },
                {
                    "name" : "filter",
                    "description : "только что помыли",
                    "icon" : "https://"
                    "type" : "type"
                }],
            "price": 150000, // int в копейках
            "price_hr": "150.00 P",
            "active": true,
            "bg_color" : "#ffffff",
            "more_info" : {
                "name" : "почитать подробнее",
                "link" : "https://..."
            }
        },
        {
            "type" : "...",
            "name" : "продвинутый",
            "description" : "что входит",
            "details" : [],
            "price": 150000,
            "price_hr": "150.00 P",
            "active" : false,
            "bg_color" : "#ffffff",
            "more_info" : {}
        }
    ],
    "autopayment" : {
        "is_visible" : true, //false -- надо ли показывать эту секцию
        "description":"оплата",
        "details":"чтобы фичи не отвалились в самый неподходящий момент...",
        "title":"Автооплата",
        "enabled" : true, // false
        "next_payment" : {
            "description" : "следующее списание",
            "ts" : 1644230238
        }
    }
}
```

## Ручка usep_app/subscription/update

Параметры:

`type` - тип абонемента для покупки (опциональный параметр).

`auto_renewal` - флажок, показывающий, включена ли автооплата. Может быть `true / false`.

С помощью этой ручки возможно включать/выключать автооплату, а также покупать абонемент (или обновлять до более продвинутой версии).

## Ручка usep_app/subscription/taxi_screen

Данная ручка занимается отображением данных на главном экране, когда в Драйве нет машин поблизости.Работает только для пользователей с **активным** абонементом (статус тега абонемента == `active`), в остальных случаях ответ ручки будет пустым.

Параметры:

`generate=true` - сгенирировать промокод (генерация происходит по нажатию кнопки "активировать поездку").

Изначально необходимо сходить в ручку без запроса на создание промокода. API отдаст поля, описанные ниже, а также результат проверки в поле `generate`, который имеет значение `true`, если  у пользователя есть возможность получить промокод на такси.
В этом случае необходимо сделать запрос в эту же ручку с параметром `generate` для получения и активации промокода.


```(bash)
{
    "generate": true, //нужно ли делать запрос на генерацию промокода
    "available": true, //доступны ли поездки
    "title" : "Машин рядом нет ..", //или без названия, если есть активный промокод
    "subtitle" : "У вас 7/10 поездок...",
    "button" : {
        "title" : "Активировать поездку",
        "subtitle" : "И перейти в такси",
        "link" : "https://..." // если есть уже активированный промокод
    }
    "deadline" : 1649146012 // время, до которого промокод активен (если уже есть активированный промокод)
    "server_time" : 1649146000 // время на сервере в сек (если уже есть активированный промокод)
}
```

Если поездки на такси кончились (`available = false`), то будет отображаться другой экран с возможностью воспользоваться радаром.

```(bash)
{
    "title" : "Машин рядом нет, но есть радар",
    "subtitle" : "...",
    "available": false
}
```
