#include <bsp.h>
#include <csp_hal.h>
#include <os.h>

#include <time/time.h>

/*
volatile const char flashed_marker[8] __attribute__((section(".flashed_info"))) = "ST-Link";
volatile const char device_type_marger[48] __attribute__((section(".device_type_info"))) = "VEGA MT-32K LTE V2";
volatile const char fw_version[48] __attribute__((section(".firmware_version_info"))) = "VEGA MT-32K LTE V2 rc46 'Qashqai' VCSREV TC";
*/

namespace {
    constexpr size_t HeapSize = 150 * 1024;
    using TScheduler = NOs::TScheduler<HeapSize>;
    using TDebugStream = NBoard::NUart::TDebugStream;
    using TGsmStream = NBoard::NUart::TGsmStream;
}

class TMainTask: public NOs::NTask::ITask {
public:
    TMainTask()
        : NOs::NTask::ITask(NOs::NTask::EPriority::High, 64 * 1024)
        , Timer()
    {
    }

    virtual ~TMainTask() = default;

    void Setup() override {
        NBoard::NUart::TDebug::GetInstance()->Init(NBoard::NUart::TBaudRate::BR_115200);
        NBoard::NUart::TGsm::GetInstance()->Init(NBoard::NUart::TBaudRate::BR_115200);

        NBoard::NGpio::TRedLed::Init();

        NBoard::NGpio::TLipo::Init();
        NBoard::NGpio::TLipo::On();

        // modem pins init
        NBoard::NGpio::TModemPowerKey::Init();
        NBoard::NGpio::TModemPowerEnabled::Init();
        NBoard::NGpio::TModemStatus::Init();
        NBoard::NGpio::TModemSimSelector::Init();
        NBoard::NGpio::TModemPrecharge::Init();
        NBoard::NGpio::TModemReset::Init();
        NBoard::NGpio::TModemDischarge::Init();

        NBoard::NGpio::TModemStatus::Off();
        NBoard::NGpio::TModemPowerKey::Off();
        NBoard::NGpio::TModemPrecharge::Off();
        NBoard::NGpio::TModemSimSelector::Off();
        NBoard::NGpio::TModemReset::Off();
        NBoard::NGpio::TModemDischarge::Off();

        NBoard::NGpio::TModemDischarge::On();
        NLibrary::NTime::TTime::Delay(NLibrary::NTime::TTime::Second(2));
        NBoard::NGpio::TModemDischarge::Off();

        NBoard::NGpio::TModemPrecharge::On();
        NLibrary::NTime::TTime::Delay(NLibrary::NTime::TTime::MilliSecond(1500));
        NBoard::NGpio::TModemPrecharge::Off();

        NBoard::NGpio::TModemPowerEnabled::On();
        NLibrary::NTime::TTime::Delay(NLibrary::NTime::TTime::MilliSecond(530));

        NBoard::NGpio::TModemPowerKey::On();
        NLibrary::NTime::TTime::Delay(NLibrary::NTime::TTime::MilliSecond(100));
        NBoard::NGpio::TModemPowerKey::Off();
        NLibrary::NTime::TTime::Delay(NLibrary::NTime::TTime::Second(1));

        Timer.Start();
    }

    void Loop() override {
        using namespace NLibrary::NStream;

        if (Timer.HasExpired(NLibrary::NTime::TTime::Second(1))) {
            Timer.Start();
            NBoard::NGpio::TRedLed::Toggle();

            TGsmStream() << "TEST COUNTER " << NLibrary::NUtil::ToString(Counter) << Endl;
            TDebugStream() << "Send gsm test message" << Endl;

            Counter++;
        }
        NLibrary::NTime::TTime::Delay(NLibrary::NTime::TTime::MilliSecond(10));
    }

    const char* GetName() const override {
        return "main_t";
    }

private:
    NLibrary::NTime::TTimer Timer;
    size_t Counter = 0;
};

int main()
{
    NBoard::Init();

    TScheduler::Init();
    TScheduler::Register<TMainTask>();
    TScheduler::Start();

    return 0;
}
