#pragma once

namespace NBoard {
    namespace NGpio {
        template<class TGpio, bool Invert = false>
        class TRelay {
        public:
            TRelay() = delete;

            static void Init() {
                TGpio::Init();
            }

            static void Deinit() {
                TGpio::Deinit();
            }

            static void On() {
                if (Invert) {
                    TGpio::Off();
                } else {
                    TGpio::On();
                }
            }

            static void Off() {
                if (Invert) {
                    TGpio::On();
                } else {
                    TGpio::Off();
                }
            }

            static bool State() {
                if (Invert) {
                    return !TGpio::State();
                } else {
                    return TGpio::State();
                }
            }
        };

        template<class TGpio>
        using TInvertedRelay = TRelay<TGpio, true>;
    }
}
