#pragma once

#include "bsp_gpio.h"

#include <bsp_spi_template.h>

#include <devices/flash/device.h>
#include <devices/lis/device.h>

namespace NBoard {
    namespace NSpi {
        using TLisDataReady = NChip::NGpio::TGpio<
            NChip::NGpio::EPort::G,
            NChip::NGpio::EPin::P2,
            NChip::NGpio::EMode::Falling
        >;

        using TLisChipSelectPin = NChip::NGpio::TGpio<
            NChip::NGpio::EPort::B,
            NChip::NGpio::EPin::P12,
            NChip::NGpio::EMode::PushPull,
            NChip::NGpio::ESpeed::VeryHigh
        >;

        using TFlashChipSelectPin = NChip::NGpio::TGpio<
            NChip::NGpio::EPort::B,
            NChip::NGpio::EPin::P0,
            NChip::NGpio::EMode::PushPull,
            NChip::NGpio::ESpeed::High
        >;

        constexpr TNumber FlashNumber = TNumber::N1;
        constexpr TNumber LisNumber = TNumber::N2;

        using TLisSpi = TSpi<LisNumber, NGpio::TInvertedRelay<TLisChipSelectPin>>;
        using TFlashSpi = TSpi<FlashNumber, NGpio::TInvertedRelay<TFlashChipSelectPin>>;

        using TLis = NLibrary::NLis::TDevice<TLisSpi>;
        using TFlash = NLibrary::NFlash::TFlash<TFlashSpi>;
    }
}
