#pragma once

#include <bsp_uart_template.h>

#include <stream/stream.h>

namespace NBoard {
    namespace NUart {
        constexpr TNumber DebugNumber = TNumber::N1;
        constexpr TNumber ExternalNumber = TNumber::N2;
        constexpr TNumber GsmNumber = TNumber::N3;
        constexpr TNumber GpsNumber = TNumber::N4;
        constexpr TNumber LinNumber = TNumber::N5;

        constexpr size_t DebugStreamBufferSize = 127;
        constexpr size_t GsmStreamBufferSize = 1024;

        using TDebug = TUart<DebugNumber, TMode::Interrupt, 0, 0>;
        using TExternal = TUart<ExternalNumber, TMode::Interrupt, 2, 1024>;
        using TGsm = TUart<GsmNumber, TMode::Interrupt, 3, 1024>;
        using TGps = TUart<GpsNumber, TMode::Interrupt, 8, 128>;
        using TLin = TUart<LinNumber, TMode::Interrupt, 4, 16>;

        class TDebugStream: public NLibrary::NStream::IStringOutput<DebugStreamBufferSize> {
        public:
            using TBase = NLibrary::NStream::IStringOutput<DebugStreamBufferSize>;

            virtual ~TDebugStream() {
                CheckFlush();
            }

            void Flush() override {
                TDebug::GetInstance()->Transmit(Data.AsBytes(), Data.GetSize());
                Data.Clear();
            }
        };

        class TGsmStream: public NLibrary::NStream::IStringOutput<GsmStreamBufferSize> {
        public:
            using TBase = NLibrary::NStream::IStringOutput<GsmStreamBufferSize>;

            virtual ~TGsmStream() {
                CheckFlush();
            }

            void Flush() override {
                TGsm::GetInstance()->Transmit(Data.AsBytes(), Data.GetSize());
                Data.Clear();
            }
        };
    }
}
