#include "bsp.h"

namespace {
    using TEvent = NBoard::NUart::EEvent;
}

void NChip::NUart::TransmitCallback(ENumber number) {
    if (number == NBoard::NUart::DebugNumber) {
        NBoard::NUart::TDebug::GetInstance()->Append(TEvent::TransmitComplete);
    } else if (number == NBoard::NUart::ExternalNumber) {
        NBoard::NUart::TExternal::GetInstance()->Append(TEvent::TransmitComplete);
    } else if (number == NBoard::NUart::GpsNumber) {
        NBoard::NUart::TGps::GetInstance()->Append(TEvent::TransmitComplete);
    } else if (number == NBoard::NUart::GsmNumber) {
        NBoard::NUart::TGsm::GetInstance()->Append(TEvent::TransmitComplete);
    } else if (number == NBoard::NUart::LinNumber) {
        NBoard::NUart::TLin::GetInstance()->Append(TEvent::TransmitComplete);
    }
}

void NChip::NUart::ReceiveCallback(ENumber number, size_t size) {
    if (number == NBoard::NUart::DebugNumber) {
        NBoard::NUart::TDebug::GetInstance()->Idle(size);
    } else if (number == NBoard::NUart::ExternalNumber) {
        NBoard::NUart::TExternal::GetInstance()->Idle(size);
    } else if (number == NBoard::NUart::GpsNumber) {
        NBoard::NUart::TGps::GetInstance()->Idle(size);
    } else if (number == NBoard::NUart::GsmNumber) {
        NBoard::NUart::TGsm::GetInstance()->Idle(size);
    } else if (number == NBoard::NUart::LinNumber) {
        NBoard::NUart::TLin::GetInstance()->Idle(size);
    }
}

void NChip::NUart::ReceiveErrorCallback(ENumber number)
{
    if (number == NBoard::NUart::DebugNumber) {
        NBoard::NUart::TDebug::GetInstance()->Error();
    } else if (number == NBoard::NUart::ExternalNumber) {
        NBoard::NUart::TExternal::GetInstance()->Error();
    } else if (number == NBoard::NUart::GpsNumber) {
        NBoard::NUart::TGps::GetInstance()->Error();
    } else if (number == NBoard::NUart::GsmNumber) {
        NBoard::NUart::TGsm::GetInstance()->Error();
    } else if (number == NBoard::NUart::LinNumber) {
        NBoard::NUart::TLin::GetInstance()->Error();
    }
}