#pragma once

#include <cstddef>

namespace NChip {
    namespace NSpi {
        enum class ENumber: uint8_t {
            None = 0,
            N1,
            N2,
            N3,
            N4,
            N5
        };

        bool Init(ENumber number);
        bool Deinit(ENumber number);
        bool Transmit(ENumber number, const uint8_t* data, size_t size);
        bool Receive(ENumber number, uint8_t* data, size_t size);
        void TransmitComplete(ENumber number);
        void ReceiveComplete(ENumber number);
        void ErrorComplete(ENumber number);
    }
}
