#pragma once

#include <cstdint>

namespace NChip {
    namespace NTimer {
        enum class ENumber: uint8_t {
            None = 0,
            N1,
            N2,
            N3,
            N4,
            N5
        };

        enum class EMode: uint8_t {
            CountUp,
            CountDown
        };

        using TFrequency = uint32_t;
        using TValue = uint32_t;

        bool Init(ENumber number, EMode mode, TFrequency frequency);
        TValue Value(ENumber number);
        bool Deinit(ENumber number);
        bool EnableInterrupt(ENumber number);
        bool DisableInterrupt(ENumber number);
        void TimerCallback(ENumber number);
    }
}
