#pragma once

#include <cstdint>

namespace NChip {
    namespace NUart {
        enum class ENumber: uint8_t {
            None = 0,
            N1 = 1,
            N2 = 2,
            N3 = 3,
            N4 = 4,
            N5 = 5,
            N6 = 6,
            N7 = 7
        };

        enum EBaudRate: uint32_t {
            BR_9600 = 9600,
            BR_19200 = 19200,
            BR_38400 = 38400,
            BR_57600 = 57600,
            BR_115200 = 115200,
            BR_230400 = 230400,
            BR_256000 = 256000,
            BR_460800 = 460800,
            BR_921600 = 921600
        };

        enum class EWordLength: uint8_t {
            W8,
            W9
        };

        enum class EStopBit: uint8_t {
            S1,
            S2
        };

        enum class EParity: uint8_t {
            None,
            Even,
            Odd
        };

        enum class EFlowControl: uint8_t {
            None,
            Rts,
            Cts,
            RtsAndCts
        };

        enum class EMode: uint8_t {
            Simple = 0,
            Interrupt
        };

        struct TSetting {
            EBaudRate BaudRate = EBaudRate::BR_9600;
            EWordLength WordLength = EWordLength::W8;
            EStopBit StopBit = EStopBit::S1;
            EParity Parity = EParity::None;
            EFlowControl FlowControl = EFlowControl::None;
        };

        bool Init(ENumber number, TSetting setting);
        bool Deinit(ENumber number);
        bool Transmit(ENumber number, EMode mode, const uint8_t* data, size_t size);
        bool Receive(ENumber number, EMode mode, uint8_t* data, size_t size);
        bool AbortTransmit(ENumber number, EMode mode);
        bool AbortReceive(ENumber number, EMode mode);
        void TransmitCallback(ENumber number);
        void ReceiveCallback(ENumber number, size_t size);
        void ReceiveErrorCallback(ENumber number);
        void TransmitErrorCallback(ENumber number);
    }
}
