#pragma once

#include <cinttypes>
#include <cstddef>

namespace NChip {
    namespace NUsb {
        enum class EStatus: uint8_t {
            Default,
            Addressed,
            Configured,
            Suspended
        };

        namespace NVirtualComPort {
            void Init();
            void Deinit();
        }

        bool Transmit(const uint8_t* data, size_t size);
        void ReceiveCallback(uint8_t* data, size_t size);
    }
}
