#include "csp.h"
#include "csp_hal.h"

extern uint32_t* g_pfnVectors;

namespace NChip
{
    void Init()
    {
        /*
        __enable_irq();
        SCB->VTOR = uint32_t(&g_pfnVectors);
        */

        HAL_Init();
    }

    bool InInterrupt()
    {
        return __get_IPSR() != 0U;
    }
}

__weak void NChip::ErrorCallback(const char *file, int line)
{
    (void)file;
    (void)line;

    __disable_irq();
    while (true) {}
}

extern "C" {
    void HAL_MspInit(void)
    {
        __HAL_RCC_PWR_CLK_ENABLE();
        __HAL_RCC_SYSCFG_CLK_ENABLE();

        /* System interrupt init*/
        /* PendSV_IRQn interrupt configuration */
        HAL_NVIC_SetPriority(PendSV_IRQn, 15, 0);
    }
}
