#include <csp.h>
#include <csp_hal.h>

using THandler = TIM_HandleTypeDef;

namespace {
    using THandler = TIM_HandleTypeDef;
    using TInstance = TIM_TypeDef;
}

namespace NChip {
    namespace NTimer {
        THandler* GetTimerHandler(NChip::NTimer::ENumber number);
        ENumber GetTimerNumber(THandler* handler);
        TInstance* GetTimerInstance(ENumber number);
        NChip::NTimer::TFrequency GetTimerFrequency(ENumber number);
    }
}

namespace {
    void HalTimerElapsedHandler(TIM_HandleTypeDef* handler) {
        auto number = NChip::NTimer::GetTimerNumber(handler);

        if (number == NChip::NTimer::ENumber::None) {
            NChip::ErrorCallback(__FILE__, __LINE__);
        }

        NChip::NTimer::TimerCallback(number);
    }
}

extern "C" {
    void SysTick_Handler(void) {
        HAL_IncTick();
    }

    void HAL_TIM_PeriodElapsedCallback(TIM_HandleTypeDef *htim) {
        HalTimerElapsedHandler(htim);
    }
}
