#include <csp.h>
#include <csp_hal.h>

namespace
{
[[maybe_unused]] TIM_HandleTypeDef htim1;
[[maybe_unused]] TIM_HandleTypeDef htim2;
[[maybe_unused]] TIM_HandleTypeDef htim3;
[[maybe_unused]] TIM_HandleTypeDef htim4;
}

namespace {
    using THandler = TIM_HandleTypeDef;
    using TInstance = TIM_TypeDef;
}

namespace NChip {
    namespace NTimer {
        THandler* GetTimerHandler(NChip::NTimer::ENumber number) {
            switch (number) {
                case ENumber::N1:
                    return &htim1;
                case ENumber::N2:
                    return &htim2;
                case ENumber::N3:
                    return &htim3;
                case ENumber::N4:
                    return &htim4;
                default:
                    return nullptr;
            }
        }

        ENumber GetTimerNumber(THandler* handler) {
            if (handler->Instance == TIM1) {
                return ENumber::N1;
            } else if (handler->Instance == TIM2) {
                return ENumber::N2;
            } else if (handler->Instance == TIM3) {
                return ENumber::N3;
            } else if (handler->Instance == TIM4) {
                return ENumber::N4;
            }

            return ENumber::None;
        }

        TInstance* GetTimerInstance(ENumber number) {
            switch (number) {
                case ENumber::N1:
                    return TIM1;
                case ENumber::N2:
                    return TIM2;
                case ENumber::N3:
                    return TIM3;
                case ENumber::N4:
                    return TIM4;
                default:
                    return nullptr;
            }
        }

        NChip::NTimer::TFrequency GetTimerFrequency(ENumber number) {
            UNUSED(number);
            return 0xFFFFFFFF;
        }
    }
}









