#include <csp.h>

#include <usbd_core.h>
#include <usbd_desc.h>
#include <usbd_cdc.h>
#include <usbd_cdc_if.h>

USBD_HandleTypeDef hUsbDeviceFS;

namespace {
    void CdcReceiveFsCallback(uint8_t* data, size_t size) {
        NChip::NUsb::ReceiveCallback(data, size);
    }

    void PrivateErrorHandler() {
        NChip::ErrorCallback(__FILE__, __LINE__);
    }
}

void NChip::NUsb::NVirtualComPort::Init() {
    if (USBD_Init(&hUsbDeviceFS, &FS_Desc, DEVICE_FS) != USBD_OK) {
        NChip::ErrorCallback(__FILE__, __LINE__);
    }
    if (USBD_RegisterClass(&hUsbDeviceFS, &USBD_CDC) != USBD_OK) {
        NChip::ErrorCallback(__FILE__, __LINE__);
    }
    if (USBD_CDC_RegisterInterface(&hUsbDeviceFS, &USBD_Interface_fops_FS) != USBD_OK) {
        NChip::ErrorCallback(__FILE__, __LINE__);
    }
    if (USBD_Start(&hUsbDeviceFS) != USBD_OK) {
        NChip::ErrorCallback(__FILE__, __LINE__);
    }
}

bool NChip::NUsb::Transmit(const uint8_t* data, size_t size) {
    CDC_Transmit_FS(const_cast<uint8_t*>(data), size);
    return true;
}

__weak void NChip::NUsb::ReceiveCallback(uint8_t* data, size_t size) {
    UNUSED(data);
    UNUSED(size);
}

extern "C" {
    extern PCD_HandleTypeDef hpcd_USB_OTG_FS;

    void CDC_Receive_FS_Callback(uint8_t* Buf, uint16_t Len) {
        CdcReceiveFsCallback(Buf, Len);
    }

    void Error_Handler() {
        PrivateErrorHandler();
    }

    void OTG_FS_IRQHandler(void) {
        HAL_PCD_IRQHandler(&hpcd_USB_OTG_FS);
    }
}
