#include <csp.h>
#include <csp_hal.h>

namespace {
    using THandler = TIM_HandleTypeDef;
    using TInstance = TIM_TypeDef;
}

namespace NChip {
    namespace NTimer {
        THandler* GetTimerHandler(NChip::NTimer::ENumber number);
        ENumber GetTimerNumber(THandler* handler);
        TInstance* GetTimerInstance(ENumber number);
        NChip::NTimer::TFrequency GetTimerFrequency(ENumber number);
    }
}

bool NChip::NTimer::Init(ENumber number, EMode mode, TFrequency frequency)
{
    auto handler = GetTimerHandler(number);
    auto instance = GetTimerInstance(number);

    const TFrequency maxFrequency = 1000000;

    if (!handler || !instance) {
        NChip::ErrorCallback(__FILE__, __LINE__);
        return false;
    }

    [[maybe_unused]] TFrequency timerFreq = GetTimerFrequency(number);

    // TODO TIMERS: realize calculation prescaler and period
    TFrequency prescaler = (maxFrequency / frequency) - 1;
    TFrequency period = (maxFrequency / frequency) - 1;

    handler->Instance = instance;

    handler->Init.ClockDivision = 0;
    if (mode == EMode::CountUp)
        handler->Init.CounterMode = TIM_COUNTERMODE_UP;
    else if (mode == EMode::CountDown)
        handler->Init.CounterMode = TIM_COUNTERMODE_DOWN;

    handler->Init.Prescaler = prescaler;
    handler->Init.Period = period;

    if (HAL_TIM_Base_Init(handler) != HAL_OK) {
        NChip::ErrorCallback(__FILE__, __LINE__);
        return false;
    }

    return true;
}

__weak void NChip::NTimer::TimerCallback(ENumber number)
{
    (void)number;
}
