#include "accelerator.h"

#include "legacy/Accel_filtr.h"
#include "legacy/Accel_move.h"
#include "legacy/Accel_tilt.h"

NLibrary::NAccelerator::TAccelerator::TAccelerator()
    : Move(false)
    , Tilt(false)
{
}

void NLibrary::NAccelerator::TAccelerator::Init() {
    AccelMove_Init();
    AccelTilt_Init();
}

void NLibrary::NAccelerator::TAccelerator::Process(TPoint point) {
    auto legacyPoint = Transform(point);
    Accel_ConvertTwoComplement(&legacyPoint);
    AccelMove_Do(legacyPoint);
    AccelTilt_Do(legacyPoint);

    Move = MovingSensor_GetState();
    Tilt = AccelTilt_GetState();
}

auto NLibrary::NAccelerator::TAccelerator::Transform(const TPoint& point) -> TLegacyPoint {
    TLegacyPoint result = {
        .X = static_cast<uint16_t>(point.X),
        .Y = static_cast<uint16_t>(point.Y),
        .Z = static_cast<uint16_t>(point.Z)
    };
    return result;
}
