#pragma once

#include <accelerator/legacy/Accel_filtr.h>
#include <devices/lis/device.h>

namespace NLibrary {
    namespace NAccelerator {
        class TAccelerator {
        public:
            using TLegacyPoint = ACCEL_POINT_16BIT;
            using TPoint = NLibrary::NLis::TPoint;

        public:
            TAccelerator();

            bool IsMove() const {
                return Move;
            }
            bool IsTilt() const {
                return Tilt;
            }

            void Init();
            void Process(TPoint point);

        private:
            bool Move;
            bool Tilt;

        private:
            TLegacyPoint Transform(const TPoint& point);
        };
    }
}
