/**
  ******************************************************************************
  * @file    sf_filter_shock.с
  * @author  Solovyev A.F.
  * @date    07-12-2012
  * @brief
  *******************************************************************************
 @verbatim
*/


/* Includes ------------------------------------------------------------------*/
#include "accelerator/legacy/Accel_filtr.h"

/* Defines -------------------------------------------------------------------*/

/* Exported types ------------------------------------------------------------*/


//==============================================================================
// Функция вычисляет среднеарифметическое по буферу по его заполнению
// Входные данные: in_point - входная точка 3 оси
//                 out_point - выходная точка 3 оси
//                 in_fc - управляющая структура
//                 in_buf - входной буфер данные которого усредняются
//                 in_buf_size - размер буфера
// Выходные данные: in_fc->ready - готовность функции выдавать данные
//                 out_point - выходная точка, среднеарифметическое по буферу
bool Accel_math_ma(ACCEL_POINT_16BIT in_point, ACCEL_POINT_16BIT *out_point, ACCEL_POINT_CTRL* in_fc, ACCEL_POINT_16BIT* in_buf, uint16_t in_buf_size) // возвращает статус фильтра, работает или заполняется
{

   in_buf[in_fc->cur_idx] = in_point;     // записать точку в буфер
   in_fc->cur_sum.X += in_point.X;          // скоректировать сумму
   in_fc->cur_sum.Y += in_point.Y;          // скоректировать сумму
   in_fc->cur_sum.Z += in_point.Z;          // скоректировать сумму

   in_fc->cur_idx++;                     // скоректировать счетчик
   if(in_fc->cur_idx >= in_buf_size)
     {
       in_fc->cur_idx = 0;
       in_fc->ready = true;
     }

   if(in_fc->ready == true)
   {
     out_point->X = in_fc->cur_sum.X/in_buf_size;  // вычислить среднее по буферу X
     out_point->Y = in_fc->cur_sum.Y/in_buf_size;  // вычислить среднее по буферу Y
     out_point->Z = in_fc->cur_sum.Z/in_buf_size;  // вычислить среднее по буферу Z
     in_fc->cur_sum.X = in_fc->cur_sum.X - in_buf[in_fc->cur_idx].X;
     in_fc->cur_sum.Y = in_fc->cur_sum.Y - in_buf[in_fc->cur_idx].Y;
     in_fc->cur_sum.Z = in_fc->cur_sum.Z - in_buf[in_fc->cur_idx].Z;
   }
   return(in_fc->ready);
}




//==============================================================================
// Поиск размаха
bool Accel_math_swing(ACCEL_POINT_16BIT in_point, ACCEL_POINT_16BIT *out_point, ACCEL_POINT_SWING_CTRL* in_fc, ACCEL_POINT_16BIT* in_buf, uint16_t  in_buf_size)
{
  uint8_t i;
  ACCEL_POINT_16BIT max;
  ACCEL_POINT_16BIT min;

  in_buf[in_fc->cur_idx] = in_point;     // записать точку в буфер

  in_fc->cur_idx++;                     // скоректировать счетчик
  if(in_fc->cur_idx >= in_buf_size)
  {
    in_fc->cur_idx = 0;
    in_fc->ready = true;
  }

   if(in_fc->ready == true)
   {
     max.X = in_buf[0].X;
     min.X = in_buf[0].X;
     max.Y = in_buf[0].Y;
     min.Y = in_buf[0].Y;
     max.Z = in_buf[0].Z;
     min.Z = in_buf[0].Z;

     for(i=1;i<in_buf_size;i++) // определение максимального и минимального значения буфера
     {
       if(in_buf[i].X>max.X)
       {max.X = in_buf[i].X;}
       if(in_buf[i].X<min.X)
       {min.X = in_buf[i].X;}

       if(in_buf[i].Y>max.Y)
       {max.Y = in_buf[i].Y;}
       if(in_buf[i].Y<min.Y)
       {min.Y = in_buf[i].Y;}

       if(in_buf[i].Z>max.Z)
       {max.Z = in_buf[i].Z;}
       if(in_buf[i].Z<min.Z)
       {min.Z = in_buf[i].Z;}
     }

     out_point->X = max.X - min.X;
     out_point->Y = max.Y - min.Y;
     out_point->Z = max.Z - min.Z;

   }
   return(in_fc->ready);
}



//==============================================================================
// Сброс процедуры поиска размаха
void Accel_swing_reset(ACCEL_POINT_SWING_CTRL* in_fc)
{
  in_fc->cur_idx = 0;
  in_fc->ready = false;
}


//==============================================================================
// Поиск максимального значения на интервале
bool Accel_math_power(ACCEL_POINT_16BIT in_point, uint32_t *_max_value, ACCEL_POINT_CTRL* in_fc, uint16_t  in_buf_size)
{
  // in_fc->cur_sum  используется как буфер для максимального значения на интервале
  // uint32_t complex_sum = 0x00000000;
  // complex_sum = in_point.X + in_point.Y + in_point.Z;

  if(in_point.X > in_fc->cur_sum.X)
  {
    in_fc->cur_sum.X = in_point.X;
  }
  if(in_point.Y > in_fc->cur_sum.Y)
  {
    in_fc->cur_sum.Y = in_point.Y;
  }
  if(in_point.Z > in_fc->cur_sum.Z)
  {
    in_fc->cur_sum.Z = in_point.Z;
  }

  // Не выдаем мощность, пока заданная минимальный размер фрема для анализа не получен
  if(in_fc->cur_idx >= in_buf_size)
  {
    // in_fc->cur_idx = 0;
    in_fc->ready = true;
    *_max_value = (in_fc->cur_sum.X + in_fc->cur_sum.Y + in_fc->cur_sum.Z);
  }
  else
  {
    in_fc->cur_idx++;
  }

  return(in_fc->ready);
}




//==============================================================================
// Сброс фильтра
void Accel_math_reset(ACCEL_POINT_CTRL* in_fc)
{
  in_fc->cur_idx = 0;
  in_fc->cur_sum.X = 0;
  in_fc->cur_sum.Y = 0;
  in_fc->cur_sum.Z = 0;
  in_fc->ready = false;
}


//------------------------------------------------------------------------------
// Конвертировать слово-сэмпл от акселерометра из доплнительного кода в прямой
// Выходные данный: 12-битный семпл в прямом коде (старшие 4 бита равны нулю)
void Accel_ConvertTwoComplement(ACCEL_POINT_16BIT* _smp_in)
{
  if((_smp_in->X&0x8000) == 0x8000)
    {_smp_in->X = _smp_in->X & 0x7FFF;}
  else{_smp_in->X = _smp_in->X | 0x8000;}
  _smp_in->X = _smp_in->X>>4;

  if((_smp_in->Y&0x8000) == 0x8000)
    {_smp_in->Y = _smp_in->Y & 0x7FFF;}
  else{_smp_in->Y = _smp_in->Y | 0x8000;}
  _smp_in->Y = _smp_in->Y>>4;

  if((_smp_in->Z&0x8000) == 0x8000)
    {_smp_in->Z = _smp_in->Z & 0x7FFF;}
  else{_smp_in->Z = _smp_in->Z | 0x8000;}
  _smp_in->Z = _smp_in->Z>>4;
}



