/**
  ******************************************************************************
  * @file    Accel_filtr.h
  * @author  Solovyev A.F.
  * @date    12-12-2012
  * @brief   
  *******************************************************************************
 @verbatim
*/


#ifndef __ACCEL_FILTR_H
#define __ACCEL_FILTR_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include <stdbool.h>

/* Defines -------------------------------------------------------------------*/

/* Exported types ------------------------------------------------------------*/
typedef struct {
  uint32_t X;
  uint32_t Y;
  uint32_t Z;
} ACCEL_POINT_32BIT;

typedef struct {
  uint16_t X;
  uint16_t Y;
  uint16_t Z;
} ACCEL_POINT_16BIT;

typedef struct {
  ACCEL_POINT_32BIT cur_sum; 	//    
  uint16_t cur_idx; 		//   
  bool ready; 			//   -  
} ACCEL_POINT_CTRL;

typedef struct {
  uint16_t cur_idx;
  bool ready;
} ACCEL_POINT_SWING_CTRL;

//* Exported function prototypes ----------------------------------------------*/
bool Accel_math_ma(ACCEL_POINT_16BIT in_point, ACCEL_POINT_16BIT *out_point, ACCEL_POINT_CTRL* in_fc, ACCEL_POINT_16BIT* in_buf, uint16_t  in_buf_size); //   ,   
bool Accel_math_swing(ACCEL_POINT_16BIT in_point, ACCEL_POINT_16BIT *out_point, ACCEL_POINT_SWING_CTRL* in_fc, ACCEL_POINT_16BIT* in_buf, uint16_t  in_buf_size);
void Accel_swing_reset(ACCEL_POINT_SWING_CTRL* in_fc);

bool Accel_math_power(ACCEL_POINT_16BIT in_point, uint32_t *_max_value, ACCEL_POINT_CTRL* in_fc, uint16_t  in_buf_size);
void Accel_math_reset(ACCEL_POINT_CTRL* in_fc);
void Accel_ConvertTwoComplement(ACCEL_POINT_16BIT* _smp_in);

#ifdef __cplusplus
}
#endif


#endif  // __ACCEL_FILTR_H

