#pragma once

#include <cstddef>
#include <cinttypes>

namespace NLibrary {
    namespace NFlash {
        enum Commands : uint8_t {
            CMD_READ_STATUS = 0x05,
            CMD_READ = 0x0B,
            CMD_WRITE_ENABLE = 0x06,
            CMD_WRITE_DISABLE = 0x04,
            CMD_WRITE = 0x02,
            CMD_WRITE_STATUS = 0x01,
            CMD_PROTECT_SECTOR = 0x36,
            CMD_UNPROTECT_SECTOR = 0x39,
            CMD_READ_SECTOR_PROTECTION = 0x3C,
            CMD_ERASE_4K = 0x20,
            CMD_ERASE_32K = 0x52,
            CMD_ERASE_64K = 0xD8,
            CMD_ERASE_CHIP = 0x60,
            CMD_RESET_ENABLE = 0x66,
            CMD_RESET_MEMORY = 0x99,
            CMD_READ_ID = 0x9F,
            CMD_FOUR_BYTE_ADDRESSING = 0xB7
        };

        constexpr uint32_t SST25VF064C_ID = 0x00BF254B;
        constexpr uint32_t S25FL164K_ID = 0x00014017;
        constexpr uint32_t MX25L6435E_ID = 0x00C22017;
        constexpr uint32_t IS25LP256D_ID = 0x009D6019;
        constexpr uint32_t AT25SF641_ID = 0x001F3217;
        constexpr uint32_t MX25L25645G_ID = 0x00C22019;
    }
}
