#include "flash_translation.h"

NLibrary::NFilesystem::NVega::THeader::THeader(uint8_t busy, uint16_t address, uint32_t wearLevel, uint8_t outMoveStart, uint8_t inMoveEnd)
    : Busy(busy)
    , Address(address)
    , WearLevel(wearLevel)
    , OutMoveStart(outMoveStart)
    , InMoveEnd(inMoveEnd)
{
}

void NLibrary::NFilesystem::NVega::THeader::Pack(uint8_t* data, size_t size) const {
    assert(size >= GetSize());
    (void)size;

    data[0] = Busy;
    data[1] = (Address >> 8) & 0xFF;
    data[2] = (Address >> 0) & 0xFF;
    data[3] = (WearLevel >> 24) & 0xFF;
    data[4] = (WearLevel >> 16) & 0xFF;
    data[5] = (WearLevel >> 8) & 0xFF;
    data[6] = (WearLevel >> 0) & 0xFF;
    data[7] = OutMoveStart;
    data[8] = InMoveEnd;
}

void NLibrary::NFilesystem::NVega::THeader::Unpack(const uint8_t* data, size_t size) {
    assert(size >= GetSize());
    (void)size;

    Busy = data[0];
    Address = (data[2] << 8) | data[1];
    WearLevel = (data[6] << 24) | (data[5] << 16) | (data[4] << 8) | data[3];
    OutMoveStart = data[7];
    InMoveEnd = data[8];
}

NLibrary::NFilesystem::NVega::TLogicalAddressItem::TLogicalAddressItem(bool busy, uint16_t address)
    : Busy(busy)
    , Address(address)
{
}

NLibrary::NFilesystem::NVega::TLogicalAddressItem::TLogicalAddressItem(const THeader& header)
    : Busy(header.Busy)
    , Address(header.Address)
{
}

NLibrary::NFilesystem::NVega::TLogicalAddressRecoveryInfo::TLogicalAddressRecoveryInfo(bool eventFlag, bool withCorrupt, bool status, uint16_t sector)
    : EventFlag(eventFlag)
    , WithCorrupt(withCorrupt)
    , Status(status)
    , Sector(sector)
{
}

void NLibrary::NFilesystem::NVega::TLogicalAddressRecoveryInfo::Pack(uint8_t* data, size_t size) const {
    assert(size >= GetSize());
    (void)size;

    data[0] |= EventFlag << 0;
    data[0] |= WithCorrupt << 1;
    data[0] |= Status << 2;
    data[0] |= ((Sector >> 8) & 0x1F) << 3;
    data[1] |= Sector & 0xFF;
}

void NLibrary::NFilesystem::NVega::TLogicalAddressRecoveryInfo::Unpack(const uint8_t* data, size_t size) {
    assert(size >= GetSize());
    (void)size;

    EventFlag = data[0] & (1 << 0);
    WithCorrupt = data[0] & (1 << 1);
    Status = data[0] & (1 << 2);
    Sector = (((data[0] >> 3) & 0x1F) << 8) | data[1];
}
