#pragma once

namespace NLibrary {
    namespace NLock {
        class ILockable {
        public:
            virtual ~ILockable() = default;

            virtual void Lock() = 0;
            virtual void Unlock() = 0;
        };

        class TLock final {
        public:
            explicit TLock(ILockable& lockable);
            ~TLock();

        private:
            ILockable& Lockable;
        };
    }
}
