#include <stream/stream.h>

#include <time/timer.h>

size_t NLibrary::NStream::IInput::Load(uint8_t* data, size_t size) {
    size_t count = 0;

    while (count < size) {
        int item = TimedRead();
        if (item < 0) {
            break;
        }
        *data++ = static_cast<uint8_t>(item);
        count++;
    }

    return count;
}

size_t NLibrary::NStream::IInput::Load(uint8_t* data, size_t size, uint8_t terminator) {
    size_t count = 0;

    while (count < size) {
        int item = TimedRead();
        if (item < 0 || item == terminator) {
            break;
        }
        *data = static_cast<uint8_t>(item);
        count++;
    }

    return count;
}

int NLibrary::NStream::IInput::TimedRead() {
    int result = -1;

    NTime::TTimer timer;
    timer.Start();

    do {
        result = Read();
        if (result >= 0) {
            return result;
        }
        NTime::TTime::Delay(NTime::TTime::MilliSecond(1));

    } while (!timer.HasExpired(Timeout));

    return -1;
}

int NLibrary::NStream::IInput::TimedPeek() {
    int result = -1;

    NTime::TTimer timer;
    timer.Start();

    do {
        result = Peek();
        if (result >= 0) {
            return result;
        }
        NTime::TTime::Delay(NTime::TTime::MilliSecond(1));

    } while (!timer.HasExpired(Timeout));

    return -1;
}
