#pragma once

#include <os.h>

#include <time/time.h>

namespace NLibrary {
    namespace NTime {
        class TTimer {
        public:
            TTimer() = default;

            void Start() {
                Time = TTime::Now();
                Started = true;
            }
            bool IsStarted() const {
                return Started;
            }
            TTime Elapsed() const {
                return TTime::Now() - Time;
            }
            bool HasExpired(const TTime time) {
                return Elapsed() >= time;
            }
        private:
            bool Started;
            TTime Time;
        };
    }
}
