#pragma once

#include <concepts>

namespace NLibrary {
    namespace NUtil {
        template<typename T>
        concept TPointItem = std::integral<T> || std::floating_point<T>;

        template<TPointItem TItem>
        struct TPoint {
            TItem X;
            TItem Y;
            TItem Z;

            TPoint()
                : X()
                , Y()
                , Z()
            {
            }

            TPoint(TItem x, TItem y, TItem z = TItem())
                : X(x)
                , Y(y)
                , Z(z)
            {
            }

            TPoint& operator+=(const TPoint& rhs) {
                X += rhs.X;
                Y += rhs.Y;
                Z += rhs.Z;
                return *this;
            }

            TPoint& operator-=(const TPoint& rhs) {
                X -= rhs.X;
                Y -= rhs.Y;
                Z -= rhs.Z;
                return *this;
            }

            TPoint& operator*=(const TPoint& rhs) {
                X *= rhs.X;
                Y *= rhs.Y;
                Z *= rhs.Z;
                return *this;
            }

            TPoint& operator/=(const TPoint& rhs) {
                X /= rhs.X;
                Y /= rhs.Y;
                Z /= rhs.Z;
                return *this;
            }
        };
    }
}

template<NLibrary::NUtil::TPointItem TItem>
inline bool operator==(const NLibrary::NUtil::TPoint<TItem>& lhs, const NLibrary::NUtil::TPoint<TItem>& rhs) {
    return lhs.X == rhs.X && lhs.Y == rhs.Y && lhs.Z == rhs.Z;
}

template<NLibrary::NUtil::TPointItem TItem>
inline bool operator!=(const NLibrary::NUtil::TPoint<TItem>& lhs, const NLibrary::NUtil::TPoint<TItem>& rhs) {
    return !operator==<TItem>(lhs, rhs);
}

template<NLibrary::NUtil::TPointItem TItem>
inline NLibrary::NUtil::TPoint<TItem> operator+(const NLibrary::NUtil::TPoint<TItem>& lhs, const NLibrary::NUtil::TPoint<TItem>& rhs) {
    return {
        lhs.X + rhs.X,
        lhs.Y + rhs.Y,
        lhs.Z + rhs.Z
    };
}

template<NLibrary::NUtil::TPointItem TItem>
inline NLibrary::NUtil::TPoint<TItem> operator+(const NLibrary::NUtil::TPoint<TItem>& lhs, const TItem& rhs) {
    return {
        lhs.X + rhs,
        lhs.Y + rhs,
        lhs.Z + rhs
    };
}

template<NLibrary::NUtil::TPointItem TItem>
inline NLibrary::NUtil::TPoint<TItem> operator-(const NLibrary::NUtil::TPoint<TItem>& lhs, const NLibrary::NUtil::TPoint<TItem>& rhs) {
    return {
        lhs.X - rhs.X,
        lhs.Y - rhs.Y,
        lhs.Z - rhs.Z
    };
}

template<NLibrary::NUtil::TPointItem TItem>
inline NLibrary::NUtil::TPoint<TItem> operator-(const NLibrary::NUtil::TPoint<TItem>& lhs, const TItem& rhs) {
    return {
        lhs.X - rhs,
        lhs.Y - rhs,
        lhs.Z - rhs
    };
}

template<NLibrary::NUtil::TPointItem TItem>
inline NLibrary::NUtil::TPoint<TItem> operator*(const NLibrary::NUtil::TPoint<TItem>& lhs, const NLibrary::NUtil::TPoint<TItem>& rhs) {
    return {
        lhs.X * rhs.X,
        lhs.Y * rhs.Y,
        lhs.Z * rhs.Z
    };
}

template<NLibrary::NUtil::TPointItem TItem>
inline NLibrary::NUtil::TPoint<TItem> operator*(const NLibrary::NUtil::TPoint<TItem>& lhs, const TItem& rhs) {
    return {
        lhs.X * rhs,
        lhs.Y * rhs,
        lhs.Z * rhs
    };
}

template<NLibrary::NUtil::TPointItem TItem>
inline NLibrary::NUtil::TPoint<TItem> operator/(const NLibrary::NUtil::TPoint<TItem>& lhs, const NLibrary::NUtil::TPoint<TItem>& rhs) {
    return {
        lhs.X / rhs.X,
        lhs.Y / rhs.Y,
        lhs.Z / rhs.Z
    };
}

template<NLibrary::NUtil::TPointItem TItem>
inline NLibrary::NUtil::TPoint<TItem> operator/(const NLibrary::NUtil::TPoint<TItem>& lhs, const TItem& rhs) {
    return {
        lhs.X / rhs,
        lhs.Y / rhs,
        lhs.Z / rhs
    };
}
