#pragma once

#include <os.h>
#include <lock/lock.h>

namespace NLibrary {
    namespace NUtil {
        template<class TInstance>
        class TSingleton {
        public:
            using TInstancePtr = TInstance*;

        public:
            TSingleton(const TSingleton&) = delete;
            TSingleton& operator=(const TSingleton&) = delete;

            static TInstancePtr GetInstance() {
                if (!Instance) {
                    NLock::TLock lock(Mutex);
                    Instance = new TInstance();
                }
                return Instance;
            }

            static void RemoveInstance() {
                if (Instance) {
                    NLock::TLock lock(Mutex);
                    delete Instance;
                }
            }

        protected:
            TSingleton() = default;

        private:
            inline static TInstancePtr Instance = nullptr;
            inline static NOs::TMutex Mutex;
        };
    }
}
