#include "os.h"

auto NOs::NMutex::Create() -> TId {
    return xSemaphoreCreateMutex();
}

bool NOs::NMutex::Lock(TId id) {
    if (!NOs::IsStarted()) {
        return true;
    }

    return (xSemaphoreTake(id, portMAX_DELAY) == pdTRUE);
}

void NOs::NMutex::Unlock(TId id) {
    if (!NOs::IsStarted()) {
        return;
    }

    xSemaphoreGive(id);
}

void NOs::NMutex::Remove(TId id) {
    vSemaphoreDelete(id);
}

auto NOs::NRecursiveMutex::Create() -> TId {
    return xSemaphoreCreateRecursiveMutex();
}

bool NOs::NRecursiveMutex::Lock(TId id) {
    if (!NOs::IsStarted()) {
        return true;
    }
    return (xSemaphoreTakeRecursive(id, portMAX_DELAY) == pdTRUE);
}

void NOs::NRecursiveMutex::Unlock(TId id) {
    if (!NOs::IsStarted()) {
        return;
    }
    xSemaphoreGiveRecursive(id);
}

void NOs::NRecursiveMutex::Remove(TId id) {
    vSemaphoreDelete(id);
}
