#include <os.h>

auto NOs::NQueue::Create(size_t count, size_t size) -> TId {
    return xQueueCreate(count, size);
}

bool NOs::NQueue::Put(TId id, const void *data, size_t size) {
    (void)size;

    if (xPortIsInsideInterrupt() == pdTRUE) {
        BaseType_t xHigherPriorityTaskWoken = pdFALSE;
        return xQueueSendFromISR(id, data, &xHigherPriorityTaskWoken) == pdTRUE;
    }

    return xQueueSend(id, data, portMAX_DELAY) == pdTRUE;
}

bool NOs::NQueue::Get(TId id, void* data, size_t size) {
    (void)size;

    if (xPortIsInsideInterrupt() == pdTRUE) {
        BaseType_t xHigherPriorityTaskWoken = pdFALSE;
        return xQueueReceiveFromISR(id, data, &xHigherPriorityTaskWoken);
    }

    return xQueueReceive(id, data, portMAX_DELAY) == pdTRUE;
}

bool NOs::NQueue::Peek(TId id, void* data, size_t size) {
    (void)size;

    if (xPortIsInsideInterrupt() == pdTRUE) {
        return xQueuePeekFromISR(id, data);
    }

    return xQueuePeek(id, data, portMAX_DELAY) == pdTRUE;
}

size_t NOs::NQueue::GetSize(TId id) {
    if (xPortIsInsideInterrupt() == pdTRUE)
        return uxQueueMessagesWaitingFromISR(id);

    return uxQueueMessagesWaiting(id);
}

void NOs::NQueue::Remove(TId id) {
    vQueueDelete(id);
}

void NOs::NQueue::Clear(TId id) {
    xQueueReset(id);
}
