#include <os.h>

auto NOs::NTask::Current() -> TTick {
    return xTaskGetTickCount();
}

void NOs::NTask::Delay(TTick tick) {
    vTaskDelay(tick);
}

void NOs::NTask::Yield() {
    taskYIELD();
}

bool NOs::NTask::ITask::Start() {
    TStack currentStack = GetStack();

    if ((currentStack % sizeof(TStack)) != 0) {
        currentStack = ((currentStack / sizeof(TStack)) + 1) * sizeof(TStack);
    }

    auto status = xTaskCreate(
        StartFunction,
        GetName(),
        currentStack / sizeof(TStack),
        this,
        static_cast<UBaseType_t>(GetPriority()),
        &Id
    );

    return status == pdPASS;
}

void NOs::NTask::ITask::StartFunction(TArgument argument) {
    auto self = reinterpret_cast<NOs::NTask::ITask*>(argument);

    self->Setup();

    while (true) {
        self->Loop();
    }

    vTaskDelete(self->Id);
}
