#include "os_template.h"

#include <cstdint>

extern "C" void* malloc(size_t size) {
    return NOs::Alloc(size);
}

extern "C" void free(void* block) {
    NOs::Free(block);
}

void* operator new(size_t size) noexcept {
    return NOs::Alloc(size);
}

void* operator new[](size_t size) noexcept {
    return NOs::Alloc(size);
}

void operator delete(void* block) noexcept {
    NOs::Free(block);
}

void operator delete(void* block, size_t size) noexcept {
    (void)size;
    NOs::Free(block);
}

void operator delete[](void* block) noexcept {
    NOs::Free(block);
}

void operator delete[](void* block, size_t size) noexcept {
    (void)size;
    NOs::Free(block);
}
