#pragma once

#include <cstdint>

namespace NOs {
    namespace NEvent {
        class TData final {
        public:
            using TId = uint32_t;
            using TData = uint32_t;

        public:
            EventData(TId id, TData data)
                : _id(id), _data(data)
            {
            }

            TId GetId() const {
                return Id;
            }
            TData GetData() const {
                return Data;
            }

            void Set(TId id, TData data) {
                Id = id;
                Data = data;
            }
            void SetId(TId id) {
                Id = id;
            }
            void SetData(TData data) {
                Data = data;
            }

        private:
            TId Id;
            TData Data;
        };
    }
}
