#pragma once

#include <os_hal.h>

namespace NOs {
    namespace NTask {

        enum class EPriority: uint8_t
        {
            Idle = 0,
            Low,
            Normal,
            High,
            RealTime
        };

        using TTick = uint32_t;

        TTick Current();
        void Delay(TTick tick);
        void Yield();

        class ITask {
        public:
            using TId = NOs::NTask::TId;
            using TStack = size_t;
            using TPriority = NOs::NTask::EPriority;
            using TArgument = void*;

        public:
            ITask(TPriority priority, TStack stack)
                : Stack(stack), Priority(priority), Id(NOs::NTask::EmptyId)
            {
            }

            virtual ~ITask() = default;

            bool Start();

            virtual const char* GetName() const {
                return "none";
            }
            TStack GetStack() const {
                return Stack;
            }
            TPriority GetPriority() const {
                return Priority;
            }

        protected:
            virtual void Setup() = 0;
            virtual void Loop() = 0;

        protected:
            TStack Stack;
            TPriority Priority;

        private:
            TId Id;

        private:
            static void StartFunction(TArgument argument);
        };
    }
}
