#pragma once

#include "os_task_template.h"

#include <cstdint>
#include <list>
#include <utility>

namespace NOs {
    bool Init();
    bool Start();
    bool Stop();

    void* Alloc(size_t size);
    void Free(void* ptr);

    bool IsStarted();

    bool BlockInit(uint8_t* ptr, size_t size);

    template<size_t HeapSize>
    class TScheduler final {
    public:
        using TTaskPtr = NOs::NTask::ITask*;
        using TCollection = std::list<TTaskPtr>;

        TScheduler() = delete;

        static bool Init() {
            if (!NOs::BlockInit(Heap, HeapSize)) {
                return false;
            }
            if (!NOs::Init()) {
                return false;
            }

            return true;
        }

        template<typename T, typename... Args>
        static void Register(Args&&... args) {
            static_assert(std::is_base_of<NOs::NTask::ITask, T>::value);
            Tasks.emplace_back(new T(std::forward(args)...));
        }

        static bool Start() {
            for (auto&& task : Tasks) {
                task->Start();
            }

            return NOs::Start();
        }

        static bool Stop() {
            return NOs::Stop();
        }

    private:
        inline static uint8_t Heap[HeapSize];
        inline static TCollection Tasks;
        inline static size_t TasksCount = 0;
    };
}
