#include <os.h>

#include <queue>
#include <map>
#include <memory>
#include <cstring>

namespace
{
//using internal_map_t = std::map<std::uint32_t, std::unique_ptr<void>>;
//using item_t = std::unique_ptr<>;
using item_t = std::queue<void*>;
using internal_map_t = std::map<os::queue::id_t, item_t>;
std::uint32_t current_id = 1;

internal_map_t container;
}

auto os::queue::create(std::size_t count, std::size_t size) -> id_t
{
    container[current_id] = item_t();
    return current_id++;
}

bool os::queue::put(id_t id, const void *data, std::size_t size)
{
    //return false;
    assert(id != os::queue::empty_id);

    void* result = os::alloc(size);
    memcpy(result, data, size);

    container[id].push(result);

    return result != nullptr;
}

bool os::queue::get(id_t id, void *data, std::size_t size)
{
    assert(id != os::queue::empty_id);
    assert(container.contains(id));

    void* result = container[id].front();
    //data = result;
    memcpy(data, result, size);
    container[id].pop();
    os::free(result);

    return data != nullptr;
}

std::size_t os::queue::size(id_t id)
{
    assert(id != os::queue::empty_id);
    assert(container.contains(id));

    return container[id].size();
}

void os::queue::remove(id_t id)
{
    assert(id != os::queue::empty_id);
    assert(container.contains(id));

    current_id--;
}

void os::queue::clear(id_t id)
{
    assert(id != os::queue::empty_id);
    assert(container.contains(id));

    for (std::size_t i = 0; i < container[id].size(); ++i) {
        container[id].pop();
    }
}
