#include <data/queue.h>
#include <data/string.h>
#include <data/vector.h>

#include <library/cpp/logger/global/global.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(Data) {
    Y_UNIT_TEST(Vector) {
        using TVector = NLibrary::NData::TVector<uint8_t, 3>;

        TVector vector;

        UNIT_ASSERT(!vector.IsFull());
        UNIT_ASSERT(vector.IsEmpty());

        vector.PushBack(0x13);
        vector.PushBack(0x14);
        vector.PushBack(0x15);
        vector.PushBack(0x16);

        UNIT_ASSERT_EQUAL(vector[0], 0x13);
        UNIT_ASSERT_EQUAL(vector[1], 0x14);
        UNIT_ASSERT_EQUAL(vector[2], 0x15);
        UNIT_ASSERT_UNEQUAL(vector[3], 0x16);

        UNIT_ASSERT(vector.IsFull());
        UNIT_ASSERT(!vector.IsEmpty());

        vector.PopBack();

        UNIT_ASSERT_UNEQUAL(vector[3], 0x15);
        UNIT_ASSERT_EQUAL(vector.GetSize(), 2);

        UNIT_ASSERT(!vector.IsFull());
        UNIT_ASSERT(!vector.IsEmpty());
    }

    Y_UNIT_TEST(Queue) {
        using TQueue = NLibrary::NData::TQueue<uint8_t, 3>;

        {
            TQueue queue;

            queue.Push(0x13);
            queue.Push(0x14);
            queue.Push(0x15);
            queue.Push(0x16);

            UNIT_ASSERT(queue.IsFull());
            UNIT_ASSERT(!queue.IsEmpty());

            UNIT_ASSERT_EQUAL(queue.Pop(), 0x13);
            UNIT_ASSERT(!queue.IsFull());
            UNIT_ASSERT_EQUAL(queue.Pop(), 0x14);
            UNIT_ASSERT_EQUAL(queue.Pop(), 0x15);

            UNIT_ASSERT(!queue.IsFull());
            UNIT_ASSERT(queue.IsEmpty());
        }
    }

    Y_UNIT_TEST(String) {
        using TString = NLibrary::NData::TString<16>;

        {
            NLibrary::NData::TString<4> data;

            UNIT_ASSERT(data.IsEmpty());
            UNIT_ASSERT_EQUAL(data.GetSize(), 0);

            data.Append('A');
            data.Append('B');

            UNIT_ASSERT_EQUAL(data, "AB");

            data.Append('C');
            data.Append('D');
            data.Append('E');

            UNIT_ASSERT_UNEQUAL(data, "ABCDE");
            UNIT_ASSERT(data.IsFull());
            UNIT_ASSERT(!data.IsEmpty());
        }

        {
            TString data;

            data.Append("ABCD");

            UNIT_ASSERT(data.Equal("ABCD"));
            UNIT_ASSERT(!data.Equal("ABC"));
        }

        {
            TString data("A");
            TString emptyData;

            UNIT_ASSERT(data.StartsWith('A'));
            UNIT_ASSERT(!data.StartsWith('B'));
            UNIT_ASSERT(!emptyData.StartsWith('A'));
        }
    }
}
