#include <library/cpp/logger/global/global.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/point.h>
#include <util/util.h>

Y_UNIT_TEST_SUITE(Util) {
    Y_UNIT_TEST(ToString) {
        using namespace NLibrary::NUtil;

        UNIT_ASSERT_EQUAL(ToString(uint32_t(4294967295)), "4294967295");
        UNIT_ASSERT_EQUAL(ToString(uint32_t(0xFFFFFFFF), EIntegerBase::Hex), "FFFFFFFF");
        UNIT_ASSERT_EQUAL(ToString(uint32_t(0b11111111111111111111111111111111), EIntegerBase::Bin), "11111111111111111111111111111111");
        UNIT_ASSERT_EQUAL(ToString(uint32_t(037777777777), EIntegerBase::Oct), "37777777777");

        UNIT_ASSERT_EQUAL(ToString(int32_t(-3214)), "-3214");
        UNIT_ASSERT_EQUAL(ToString(uint8_t(28)), "28");
        UNIT_ASSERT_EQUAL(ToString(int8_t(-64)), "-64");

        UNIT_ASSERT_EQUAL(ToString(32.1234f), "32.12");
        UNIT_ASSERT_EQUAL(ToString(32.1234f, 3), "32.123");
        UNIT_ASSERT_EQUAL(ToString(32.1234f, 4), "32.1234");
        UNIT_ASSERT_EQUAL(ToString(-32.1234f, 4), "-32.1234");
    }

    Y_UNIT_TEST(Point) {
        using TPoint = NLibrary::NUtil::TPoint<i16>;
        using TPointF = NLibrary::NUtil::TPoint<float>;
        {
            TPoint point{32, 15, 21};
            UNIT_ASSERT_EQUAL(point, TPoint(32, 15, 21));
            UNIT_ASSERT(point != TPoint(15, 32, 21));

            point += TPoint(15, 21, 32);
            UNIT_ASSERT_EQUAL(point, TPoint(47, 36, 53));

            point -= TPoint(2, 3, 4);
            UNIT_ASSERT_EQUAL(point, TPoint(45, 33, 49));

            point *= TPoint(2, 2, 2);
            UNIT_ASSERT_EQUAL(point, TPoint(90, 66, 98));

            point /= TPoint(2, 2, 2);
            UNIT_ASSERT_EQUAL(point, TPoint(45, 33, 49));
        }

        {
            TPointF point{32.2f, 15.5f, 21.9f};
            UNIT_ASSERT_EQUAL(point, TPointF(32.2f, 15.5f, 21.9f));
            UNIT_ASSERT_UNEQUAL(point, TPointF(15, 32, 21));
        }
    }
}

