import * as assert from 'assert';
import {NPMLoggingLevel} from 'winston';

export interface Config {
    'logger.colorize': boolean;
    'logger.level': NPMLoggingLevel;
    url: {
        yadro: string;
    },
    request: {
        timeout: number;
        retries: number;
    }
}

const production: Config = {
    'logger.colorize': false,
    'logger.level': 'info',
    url: {
        yadro: `https://api.yadrocrm.ru/integration/site?key=${process.env.YADRO_ID}`
    },
    request: {
        timeout: 3000,
        retries: 0
    }
};

const stress: Config = {
    ...production
};

const testing: Config = {
    ...production
};

const development: Config = {
    ...testing,
    'logger.colorize': true,
    'logger.level': 'silly'
};

const configs = new Map<string, Readonly<Config>>([
    ['production', production],
    ['stress', stress],
    ['testing', testing],
    ['development', development]
]);

const env = process.env.MAPS_STAGE || 'development';
const configForEnv = configs.get(env);
assert(configForEnv, `There is no configuration for environment "${env}"`);

export const config = configForEnv!;
