import {Request, Response} from 'express';
import * as joi from 'joi';
import * as Boom from 'boom';
import {asyncMiddleware} from '@yandex-int/express-async';

import {config} from 'app/config';
import {doRequest} from 'app/lib/do-request';

export const crmProxy = asyncMiddleware(
    async (req: Request, res: Response) => {
        const body = validate(req);

        try {
            await doRequest(config.url.yadro, {
                origin: req.hostname,
                gotOptions: {
                    method: 'POST',
                    body: processBody(body),
                    json: true,
                    form: true
                }
            });
        } catch (error) {
            if (error.statusCode) {
                res.sendStatus(error.statusCode).end();
                return;
            } else {
                throw error;
            }
        }

        res.end();
    }
);

function processBody(body: any) {
    const carData = body.car.match(/^(.*?) (.*?) \((.*?)\)$/i);
    body.car_mark = carData[1];
    body.car_model = carData[2];
    body.car_year = carData[3];
    return body;
}

const schema = joi.object({
    person: joi.string().trim().required(),
    user_agent: joi.string().trim().required(),
    car: joi.string().trim().required(),
    town: joi.string(),
    region: joi.string().trim().required(),
    address: joi.string(),
    email: joi.string().trim().email(),
    ip: joi.string().trim().required(),
    date: joi.string().trim().required(),
    phone: joi.string().trim().required(),

    promocode: joi.string().trim().allow(''),
    utm_source: joi.string().trim().allow(''),
    utm_medium: joi.string().trim().allow(''),
    utm_term: joi.string().trim().allow(''),
    utm_content: joi.string().trim().allow(''),
    utm_campaign: joi.string().trim().allow(''),
    refer: joi.string().trim().allow('')
});

function validate(req: Request) {
    const {error, value} = schema.validate(req.body);

    if (error) {
        throw Boom.badRequest(error.details[0].message);
    }

    return value;
}
