import {Logger, transports} from 'winston';
import {config} from 'app/config';

export const logger = new Logger();

if (!process.env.DISABLE_LOGGING) {
    logger.add(transports.Console, {
        level: config['logger.level'],
        colorize: config['logger.colorize'],
        timestamp: true,
        debugStdout: true
    });
}
