$(document).ready(function() {
	$('a.ya-zakazat').click( function(e){
		e.preventDefault();
		$('#overlay').fadeIn(400, function(){
			$('#modal_form')
				.css('display', 'block')
				.animate({opacity: 1, top: '50%'}, 200);
		});
	});
	
	$('#modal_close, #overlay').click( function(e){
		e.preventDefault();
		$('#modal_form')
			.animate({opacity: 0, top: '45%'}, 200,	function(){
				$(this).css('display', 'none');
				$('#overlay').fadeOut(400);
			}
		);
	});
});

(function() {
    window.addEventListener('message', receiveMessage, false);

    function receiveMessage(e) {
        try {
            var data = JSON.parse(e.data);
            var height = data['iframe-height'];
            var iframe;

            if (height && (iframe = findIframe(e.source))) {
                iframe.style.height = height + 'px';
            }
        } catch (err) {
        }
    }

    function findIframe(frameElement) {
        var iframeList = document.querySelectorAll('iframe');

        for (var i = 0; i < iframeList.length; ++i) {
            if (iframeList[i].contentWindow === frameElement) {
                return iframeList[i];
            }
        }
    }
})();